

#include <stream.h>
#include <SAA.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <libsil.h>
#include <alloca.h>
#include <theusual.h>
#include <matrix.h>

/*
** Other headers may be included here.
*/
/****************************************/
/*           LOCAL CONSTANTS            */
/****************************************/

/*
** Some functions have arguments that are never used.  To prevent C++ compilers
** from issuing warnings about those arguments, the following macro can be
** used.
*/
#ifdef __cplusplus
#  define _UNUSED_ARG( x )
#else
#  define _UNUSED_ARG( x ) x
#endif

/****************************************/
/*             LOCAL TYPES              */
/****************************************/

/*
** The names of global (public) functions that are given to SOFTIMAGE|3D in
** .cus files must not be mangled by C++ compilers.  If this file is being
** compiled by a C++ compiler, prevent the compiler from mangling global
** function names.
*/
#ifdef __cplusplus
extern "C" {
#endif


/****************************************/
/*      LOCAL FUNCTION PROTOTYPES       */
/****************************************/


/****************************************/
/*           LOCAL VARIABLES            */
/****************************************/
#define NICEALLOC(x) ((x)+((4-(x)%4)%4))

#define NAME_SIZE 100
  //#define N poseID
  //#define M (nb_joints*3)
#define Q 4   // # of output dimensions = 4 (xyzw)

  static SAA_Scene        scene;         /* the current scene */

  static float Sigma=500;
  static int N;
  static int M;

/****************************************/
/*           GLOBAL FUNCTIONS           */
/****************************************/

/*******************************************************************************

   $$L update

   Saaphire effect update function, executes the effect.

   Note : Make sure that the name of this function matches the name associated
   with CUSTOM_UPDATE_FUNCTION in the .cus file, or you'll get the message
   
      "Could not resolve CUSTOM_UPDATE_FUNCTION symbol for custom effect."

   Returned Value : SI_Error.

   (c) Copyright 1995, SOFTIMAGE Inc.

*******************************************************************************/

double 
rbf_M (Flotype *x0, Flotype *x) {
  double xd_2 = 0;

  // find distance 
  for (int j=0; j<M; ++j) {
    xd_2 += (x0[j]-x[j]) * (x0[j]-x[j]);
  }
  return exp(-(xd_2/Sigma));
}



SI_Error RBFcalcWeights (Flotype *x0mat, Flotype *y0mat, Flotype *w)
{
  SI_Error result = SI_SUCCESS;

  Flotype *A = MatAlloc(N, N);

  for (int i=0; i<N; ++i) {
    for (int j=0; j<N; ++j) {
      A[i*N+j] = rbf_M(&x0mat[i*M], &x0mat[j*M]);
    }
  }
  
  double det = MatInvert(A, N);
  if (det == 0.0) 
    return SI_ERR_CUSTOM_FATAL;
  else 
    MatMulN(A,y0mat,w,N,N,Q);

  MatFree(A);
  return SI_SUCCESS;
}



Flotype *getCurrJointVec (SAA_Elem patch) 
{
  Flotype *currJoint = VecAlloc(M);
  
  int UDsize, nb_joints;

  SIV ( SAA_elementGetUserDataSize( &scene, &patch, "JOINT_LIST",
				    &UDsize ) );
  SAA_Boolean bigendian;
  SAA_Elem *joints = (SAA_Elem *) calloc (UDsize, 1);
  //  int nb_joints = UDsize/sizeof(SAA_Elem);

  SIV( SAA_elementGetUserData( &scene, &patch, "JOINT_LIST",
			  UDsize, &bigendian, joints ) );
  SIV( SAA_elementGetUserData( &scene, &patch, "NB_JOINTS",
			  sizeof(int), &bigendian, &nb_joints ) );

  float x,y,z;
  for (int jI=0; jI<nb_joints; ++jI) {
    SIV(SAA_modelGetRotation(&scene, &joints[jI], SAA_COORDSYS_LOCAL,
			     &x, &y, &z));
    currJoint[jI*3 + 0] = x;
    currJoint[jI*3 + 1] = y;
    currJoint[jI*3 + 2] = z;
  }

  free(joints);
  return (currJoint);
}

void
testIt(SAA_Elem elem)
{
  int nbUD;
  SAA_elementGetNbUserData(
			   &scene, 
			   &elem, 
			   &nbUD );                 
  int *lengths = (int *) malloc(sizeof(int)*nbUD);
  char **tags = (char **) malloc(sizeof(char *)*nbUD);
  
  SAA_elementGetUserDataTagLength(
				  &scene, 
				  &elem,
				  nbUD, 
				  lengths );
  
  for(int loop2 = 0; loop2 < nbUD;loop2++)
    {
      lengths[loop2] ++;
      tags[loop2] = (char *) malloc(sizeof(char)*lengths[loop2]);
    }
  
  SAA_elementGetUserDataTag(
			    &scene, 
			    &elem, 
			    nbUD, 
			    lengths, 
			    tags );
  
  fprintf(stderr, 
	  "========================================\n");
  fprintf(stderr, "Number of Tags : %d \n", nbUD);
  for(loop2 = 0; loop2 < nbUD; loop2++)
    fprintf(stderr, "- %d : %s \n", lengths[loop2], 
	    tags[loop2]);
  fprintf(stderr, 
	  "----------------------------------------\n");
  
  free(lengths);
  for(loop2 = 0; loop2 < nbUD;loop2++)
    {
      free(tags[loop2]);
    }
  free(tags);
  
  
}


// get this first to set N and M!!!!
Flotype *getJointMatrix (SAA_Elem patch) 
{
  int UDsize, JUDsize, nb_poses;
  int nb_joints;

  SIV ( SAA_elementGetUserDataSize( &scene, &patch, "JOINT_LIST",
				    &UDsize ) );
  SAA_Boolean bigendian;
  SAA_Elem *joints = (SAA_Elem *) calloc (UDsize, 1);

  SIV( SAA_elementGetUserData( &scene, &patch, "JOINT_LIST",
			  UDsize, &bigendian, joints ) );
  SIV( SAA_elementGetUserData( &scene, &patch, "NB_JOINTS",
			  sizeof(int), &bigendian, &nb_joints ) );
  SIV( SAA_elementGetUserData( &scene, &patch, "NB_POSES",
			  sizeof(int), &bigendian, &nb_poses ) );

  N = nb_poses;
  M = nb_joints*3;
  Flotype *jointMatrix = MatAlloc(N,M);
  
  for (int jI=0; jI<nb_joints; ++jI) {
    SIV( SAA_elementGetUserDataSize( &scene, &joints[jI], 
				     "JOINT_DATA", &JUDsize ) );

    float *jointData = (float *) calloc (JUDsize, 1);
fprintf(stderr, "OH MY GOD I AM TRYING TO GET %s AND IT SAYS IT IS %d\n",silGetName(scene,joints[jI]),JUDsize);
    SIV( SAA_elementGetUserData( &scene, &joints[jI],
				 "JOINT_DATA", JUDsize, &bigendian,
				 jointData ) );
    for (int k=0; k<nb_poses; ++k) {
      jointMatrix[k*M+jI*3 + 0] = jointData[k*3 + 0];
      jointMatrix[k*M+jI*3 + 1] = jointData[k*3 + 1];
      jointMatrix[k*M+jI*3 + 2] = jointData[k*3 + 2];
    }
    free( jointData );
  }

  free( joints );

  return jointMatrix;
}  



static void
deformPatch (SAA_Elem elem) {
  int UDsize;
  int *UDsubsizes;
  SAA_DVector **verticesData, **weightsData;
  SAA_DVector *vertexData, *weightData;
  int nb_poses;
  SAA_Boolean bigendian;

  SIV(SAA_elementGetUserData ( &scene, &elem, "NB_POSES", 
                               sizeof(int), &bigendian, &nb_poses ) );
  SIV(SAA_elementGetUserData ( &scene, &elem, "SIGMA", 
                               sizeof(float), &bigendian, &Sigma ) );

  int nb_vertices;
  SIV(SAA_modelGetNbVertices(&scene, &elem, &nb_vertices));
  SAA_SubElem *ctrlVert = 
    (SAA_SubElem *) calloc ( nb_vertices, sizeof( SAA_SubElem ) );
  SAA_DVector *vertices = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );
  SIV(SAA_modelGetVertices(&scene, &elem, SAA_GEOM_ORIGINAL, 0,
                           nb_vertices, vertices));
  SIV(SAA_modelGetCtrlVertices(&scene, &elem, SAA_GEOM_ORIGINAL, 0,
                           nb_vertices, ctrlVert ) );

  SAA_Boolean *bigendianary = 
    (SAA_Boolean *) calloc (nb_vertices, sizeof(SAA_Boolean));
  weightData = 
    (SAA_DVector *) calloc ( nb_vertices*nb_poses, sizeof( SAA_DVector ) );
  weightsData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );
  UDsubsizes = 
    (int *) calloc ( nb_vertices, sizeof( int ) );

  int *UDRefsizes =
    (int *) calloc ( nb_vertices, sizeof( int ) );
  SAA_DVector *refCoord = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );
  SAA_DVector **refData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );


  SIV(SAA_subelementGetUserDataSize( &scene, &elem, nb_vertices, ctrlVert,
                                     "WEIGHT_DATA", UDsubsizes ) );
  SIV(SAA_subelementGetUserDataSize( &scene, &elem, nb_vertices, ctrlVert,
                                     "REFERENCE_DATA", UDRefsizes ) );

  for (int i=0; i<nb_vertices; ++i) {
    weightsData[i] = &weightData[i*nb_poses];
    refData[i] = &refCoord[i];
  }

  SIV(SAA_subelementGetUserData( &scene, &elem, nb_vertices, ctrlVert,
                                 "WEIGHT_DATA", UDsubsizes, bigendianary,
                                 (void **)weightsData) );
  SIV(SAA_subelementGetUserData( &scene, &elem, nb_vertices, ctrlVert,
                                 "REFERENCE_DATA", UDRefsizes, bigendianary,
                                 (void **)refData) );

  Flotype *jointMatrix = getJointMatrix(elem);
  Flotype *currJoint = getCurrJointVec(elem);

  SAA_DVector newCoord;
  for (i=0; i<nb_vertices; ++i) {
    newCoord=refCoord[i];   // initialize to reference data

    for (int j=0; j<N; ++j) {
      newCoord.x += rbf_M(&jointMatrix[j*M],currJoint)*weightsData[i][j].x;
      newCoord.y += rbf_M(&jointMatrix[j*M],currJoint)*weightsData[i][j].y;
      newCoord.z += rbf_M(&jointMatrix[j*M],currJoint)*weightsData[i][j].z;
      newCoord.w += rbf_M(&jointMatrix[j*M],currJoint)*weightsData[i][j].w;
    }      
    vertices[i]=newCoord;
  }

  SIV(SAA_modelSetVertices( &scene, &elem, SAA_GEOM_ORIGINAL, 0,
			    nb_vertices, vertices) );
    
  //  MatFree(jointMatrix);
  //  MatFree(currJoint);
  free(vertices);
  free(ctrlVert);
  free(bigendianary);
  free(weightData);
  free(weightsData);
}




static void
calcWeights (SAA_Elem elem) {
  int UDsize;
  int *UDsubsizes;
  SAA_DVector **verticesData, **weightsData;
  SAA_DVector *vertexData, *weightData;
  int nb_poses;
  SAA_Boolean bigendian;

  SIV(SAA_elementGetUserData ( &scene, &elem, "NB_POSES", 
                               sizeof(int), &bigendian, &nb_poses ) );

  int nb_vertices;
  SIV(SAA_modelGetNbVertices(&scene, &elem, &nb_vertices));
  SAA_SubElem *ctrlVert = 
    (SAA_SubElem *) calloc ( nb_vertices, sizeof( SAA_SubElem ) );
  SIV(SAA_modelGetCtrlVertices(&scene, &elem, SAA_GEOM_ORIGINAL, 0,
                           nb_vertices, ctrlVert ) );
  SAA_Boolean *bigendianary = 
    (SAA_Boolean *) calloc (nb_vertices, sizeof(SAA_Boolean));
  vertexData = 
    (SAA_DVector *) calloc ( nb_vertices*nb_poses, sizeof( SAA_DVector ) );
  weightData = 
    (SAA_DVector *) calloc ( nb_vertices*nb_poses, sizeof( SAA_DVector ) );
  verticesData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );
  weightsData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );
  UDsubsizes = 
    (int *) calloc ( nb_vertices, sizeof( int ) );
  SIV(SAA_subelementGetUserDataSize( &scene, &elem, nb_vertices, ctrlVert,
                                     "VERTEX_DATA", UDsubsizes ) );

  for (int i=0; i<nb_vertices; ++i) {
    verticesData[i] = &vertexData[i*nb_poses];
    weightsData[i] = &weightData[i*nb_poses];
  }

  SIV(SAA_subelementGetUserData( &scene, &elem, nb_vertices, ctrlVert,
                                 "VERTEX_DATA", UDsubsizes, bigendianary,
                                 (void **)verticesData) );

  Flotype *jointMatrix = getJointMatrix(elem);
  Flotype *vertexMatrix = MatAlloc(N, Q);
  Flotype *weightMatrix = MatAlloc(N, Q);

  for(int j=0; j<nb_vertices; ++j) {
    for (int k=0; k<nb_poses; ++k) {
      vertexMatrix[k*Q+0] = verticesData[j][k].x;
      vertexMatrix[k*Q+1] = verticesData[j][k].y;
      vertexMatrix[k*Q+2] = verticesData[j][k].z;
      vertexMatrix[k*Q+3] = verticesData[j][k].w;
    }
    RBFcalcWeights(jointMatrix, vertexMatrix, weightMatrix);
    for (k=0; k<nb_poses; ++k) {
      weightsData[j][k].x = weightMatrix[k*Q+0];
      weightsData[j][k].y = weightMatrix[k*Q+1];
      weightsData[j][k].z = weightMatrix[k*Q+2];
      weightsData[j][k].w = weightMatrix[k*Q+3];
    }
  }
  SIV(SAA_subelementDestroyUserData (&scene, &elem, nb_vertices, ctrlVert,
				     "WEIGHT_DATA") );
  SIV(SAA_subelementSetUserData( &scene, &elem, nb_vertices, ctrlVert,
				 "WEIGHT_DATA", UDsubsizes,
				 bigendianary, 
				 (const void **) weightsData ));
  
  MatFree(vertexMatrix);
  MatFree(jointMatrix);
  MatFree(weightMatrix);
  free(weightData);
  free(weightsData);
  free(bigendianary);
  free(vertexData);
  free(verticesData);
  free(UDsubsizes);
  free(ctrlVert);
}

static void
saveJoint (SAA_Elem target, SAA_Elem reference)
{
  int UDsize;
  float *jointData;
  int nb_poses=0;
  SAA_Boolean bigendian;
  float x,y,z;
  int posesSize;

  SIV(SAA_elementGetUserDataSize( &scene, &target, "NB_POSES", &posesSize));
  if (posesSize != 0) 
    SIV(SAA_elementGetUserData ( &scene, &target, "NB_POSES", 
				 sizeof(int), &bigendian, &nb_poses ) );
  nb_poses += 1;

  fprintf(stderr, "saving pose #%d for %s\n",
	  nb_poses, silGetName(scene,target));

  SIV(SAA_elementDestroyUserData( &scene, &target, "NB_POSES"));
  SIV(SAA_elementSetUserData ( &scene, &target, "NB_POSES",
			       sizeof(int), bigendian, &nb_poses ) );
  
  SIV ( SAA_elementGetUserDataSize( &scene, &target, "JOINT_DATA",
				    &UDsize ) );
  jointData = (float *) calloc (UDsize+sizeof(float)*3, 1);
  SIV ( SAA_elementGetUserData ( &scene, &target, "JOINT_DATA",
				 UDsize, &bigendian, jointData ) );
  
  SIV(SAA_modelGetRotation(&scene, &reference, SAA_COORDSYS_LOCAL,
			   &x, &y, &z));
  jointData[(nb_poses-1)*3+0] = x;
  jointData[(nb_poses-1)*3+1] = y;
  jointData[(nb_poses-1)*3+2] = z;

  SIV(SAA_elementDestroyUserData( &scene, &target, "JOINT_DATA"));

  SIV ( SAA_elementSetUserData( &scene, &target, "JOINT_DATA",
				UDsize+sizeof(float)*3, TRUE,
				(void *)jointData) );

}

static void
savePatch(SAA_Elem target, SAA_Elem reference)
{
  int UDsize;
  int *UDsubsizes;
  SAA_DVector **verticesData;
  SAA_DVector *vertexData;
  int nb_poses=0;
  SAA_Boolean bigendian;
  int posesSize;

  SIV(SAA_elementGetUserDataSize( &scene, &target, "NB_POSES", &posesSize));
  if (posesSize != 0) 
    SIV(SAA_elementGetUserData ( &scene, &target, "NB_POSES", 
				 sizeof(int), &bigendian, &nb_poses ) );
  nb_poses += 1;

  fprintf(stderr, "Saving pose #%d for %s\n", 
	  nb_poses, silGetName(scene, target));

  SIV(SAA_elementDestroyUserData( &scene, &target, "NB_POSES"));
  SIV(SAA_elementSetUserData ( &scene, &target, "NB_POSES",
			       sizeof(int), bigendian, &nb_poses ) );

  int nb_vertices, nb_vertices_ref;

  SIV(SAA_modelGetNbVertices(&scene, &target, &nb_vertices));
  SIV(SAA_modelGetNbVertices(&scene, &reference, &nb_vertices_ref));

  if (nb_vertices_ref != nb_vertices) {
    SIV(SAA_statusBarSet("Points do not match.  Wrong models?", 
			 SAA_ERROR_CODE));
    fprintf(stderr, 
	    "nb_vertices for target %s and reference %s do not match.\n",
	    silGetName(scene,target), silGetName(scene,reference));
  }
  
  SAA_SubElem *ctrlVert = 
    (SAA_SubElem *) calloc ( nb_vertices, sizeof( SAA_SubElem ) );
  SAA_DVector *vertices = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );

  SIV(SAA_modelGetVertices(&scene, &reference, SAA_GEOM_ORIGINAL, 0,
			   nb_vertices, vertices));
  SIV(SAA_modelGetCtrlVertices(&scene, &target, SAA_GEOM_ORIGINAL, 0,
			   nb_vertices, ctrlVert ) );
  SAA_Boolean *bigendianary = 
    (SAA_Boolean *) calloc (nb_vertices, sizeof(SAA_Boolean));
  vertexData = 
    (SAA_DVector *) calloc ( nb_vertices*nb_poses, sizeof( SAA_DVector ) );
  verticesData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );
  UDsubsizes = 
    (int *) calloc ( nb_vertices, sizeof( int ) );

  int *UDRefsizes =
    (int *) calloc ( nb_vertices, sizeof( int ) );
  SAA_DVector *refCoord = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );
  SAA_DVector **refData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );

  SIV(SAA_subelementGetUserDataSize( &scene, &target, nb_vertices, ctrlVert,
				     "VERTEX_DATA", UDsubsizes ) );
  SIV(SAA_subelementGetUserDataSize( &scene, &target, nb_vertices, ctrlVert,
				     "REFERENCE_DATA", UDRefsizes ) );

  for (int i=0; i<nb_vertices; ++i) {
    verticesData[i] = &vertexData[i*nb_poses];
    refData[i] = &refCoord[i];
  }

  SIV(SAA_subelementGetUserData( &scene, &target, nb_vertices, ctrlVert,
				 "VERTEX_DATA", UDsubsizes, bigendianary,
				 (void **)verticesData) );
  SIV(SAA_subelementGetUserData( &scene, &target, nb_vertices, ctrlVert,
				 "REFERENCE_DATA", UDRefsizes, bigendianary,
				 (void **)refData) );

  SIV(SAA_subelementDestroyUserData ( &scene, &target, nb_vertices, ctrlVert,
				      "VERTEX_DATA" ) );

  for (int j=0; j<nb_vertices; ++j) {
    verticesData[j][nb_poses-1].x = vertices[j].x - refCoord[j].x;
    verticesData[j][nb_poses-1].y = vertices[j].y - refCoord[j].y;
    verticesData[j][nb_poses-1].z = vertices[j].z - refCoord[j].z;
    verticesData[j][nb_poses-1].w = vertices[j].w - refCoord[j].w;
    UDsubsizes[j] += sizeof(SAA_DVector);
  }
  SIV(SAA_subelementSetUserData( &scene, &target, nb_vertices, ctrlVert,
				 "VERTEX_DATA", UDsubsizes,
				 bigendianary, (const void **) verticesData ));

  free(bigendianary);
  free(vertexData);
  free(verticesData);
  free(UDsubsizes);
  free(ctrlVert);
  free(vertices);
}


// erase this
static void 
siTraverse(SAA_Elem elem)
{
  SAA_ChapterType chap;
  int hl;
  int ic, nc;
  SAA_ModelType        modeltype;
  int UDsize;

  SIV(SAA_elementGetChapter(&scene, &elem, &chap));

  SIV(SAA_modelGetType( &scene, &elem, &modeltype ));
  if (modeltype == SAA_MNSRF || modeltype == SAA_MPTCH) {
    SIV ( SAA_elementGetUserDataSize( &scene, &elem, "JOINT_LIST",
				      &UDsize ) );
    if (UDsize != 0) savePatch(elem, elem);
  } else if (modeltype == SAA_MJNT) {
    SIV ( SAA_elementGetUserDataSize( &scene, &elem, "PATCH_LIST",
				     &UDsize ) );
    if (UDsize != 0) saveJoint(elem, elem);
  }

  if (chap == SAA_CHP_MODEL) {
    /*SAA_Elem *children;*/
    SIV(SAA_modelGetNbChildren(&scene, &elem, &nc));
    if (nc > 0) {
      SAA_Elem children[100];
      SIV(SAA_modelGetChildren(&scene, &elem, nc, children));
      for( ic=0; ic < nc; ic++ ) {
        siTraverse(children[ic]);
      }
    }
  }
 
} /* siTraverse */



void
elems2names (SAA_Elem *elems, char *Names, int nb_elems) {
  for (int i=0; i<nb_elems; ++i) {
    strcpy(&Names[i*NAME_SIZE], silGetName(scene, elems[i]));
  }
}



void
names2elems (char *Names, SAA_Elem *elems, int nb_elems) 
{
  SAA_Elem *selElems;
  int nbSelElems;

  SIV(    SAA_sceneGetNbModels( &scene, &nbSelElems ) );
  if( nbSelElems > 0 )
    {
      selElems =
	( SAA_Elem * ) calloc( nbSelElems, sizeof( SAA_Elem ) );
      SIV(SAA_sceneGetModels(&scene, nbSelElems, selElems ));
    }
  
  int k=0;
  for (int i=0; i<nbSelElems; ++i) {
    for (int j=0; j<nb_elems; ++j) {
      if (strcmp(silGetName(scene, selElems[i]), 
		 (const char *) &Names[j*NAME_SIZE]) == 0) {
	elems[k++] = selElems[i];
fprintf(stderr,"stored name %s in %d out of %d\n",
	silGetName(scene, selElems[i]), k-1, nb_elems);
      }
    }
  }
  free(selElems);
}


_CUS_EXTERN SI_Error RBFsavePose
   (
      SAA_CustomContext context
   )
{
   SI_Error result = SI_ERR_CUSTOM_FATAL;
   int                  hl;
   static int              nbSelElems; /* number of selected scene elements */
   static SAA_Elem         *selElems;  /* pointer on the selected elements */
   SAA_ModelType        modeltype;
   int UDsize;


   SIV(SAA_sceneInit());
   SIV(SAA_sceneGetCurrent( &scene ));

   result =
     SAA_sceneGetNbModels( &scene, &nbSelElems );
   if( result == SI_SUCCESS && nbSelElems > 0 )
     {
       selElems =
         ( SAA_Elem * ) calloc( nbSelElems, sizeof( SAA_Elem ) );
         SIV(SAA_sceneGetModels(&scene, nbSelElems, selElems ));
     }
   
   for(int i=0; i < nbSelElems; i++ ) {
     SIV(SAA_modelGetType( &scene, &selElems[i], &modeltype ));
     if (modeltype == SAA_MNSRF || modeltype == SAA_MPTCH) {
       SIV ( SAA_elementGetUserDataSize( &scene, &selElems[i], "JOINT_LIST",
					 &UDsize ) );
       if (UDsize != 0) savePatch(selElems[i], selElems[i]);
     } else if (modeltype == SAA_MJNT) {
       SIV ( SAA_elementGetUserDataSize( &scene, &selElems[i], "PATCH_LIST",
					 &UDsize ) );
       if (UDsize != 0) saveJoint(selElems[i], selElems[i]);
     }
   }
   for(i=0; i < nbSelElems; i++ ) {
     SIV(SAA_modelGetType( &scene, &selElems[i], &modeltype ));
     if (modeltype == SAA_MNSRF || modeltype == SAA_MPTCH) {
       SIV ( SAA_elementGetUserDataSize( &scene, &selElems[i], "JOINT_LIST",
					 &UDsize ) );
       if (UDsize != 0) calcWeights(selElems[i]);
     }
   }

   free(selElems);
   return SI_SUCCESS;

}  


_CUS_EXTERN SI_Error RBFsaveElement
   (
      SAA_CustomContext context
   )
{
   SI_Error result = SI_ERR_CUSTOM_FATAL;
   int                  hl;
   int                  nb_elements;
   SAA_ModelType        modeltype1, modeltype2;
   int UDsize;

   SIV(SAA_sceneInit());
   SIV(SAA_sceneGetCurrent( &scene ));

   SAA_Elem target, reference;

   SIV(SAA_selectlistGetNbElements( &scene, &nb_elements ));
   if( nb_elements == 1 ) {
     SIV(SAA_selectlistGetElements(&scene, nb_elements, &target ));
     SIV(SAA_modelGetType( &scene, &target, &modeltype1 ));
   } else {
     SIV(SAA_statusBarSet("Select only one element", SAA_ERROR_CODE));
     return SI_ERR_CUSTOM_FATAL;
   }

   SIV( SAA_customContextGetNbResults( context, &nb_elements ) );
   if( nb_elements == 1 ) {
     SIV( SAA_customContextGetResults( context, nb_elements, &reference ) );
     SIV(SAA_modelGetType( &scene, &reference, &modeltype2 ));
   } else {
     SIV(SAA_statusBarSet("Pick only one element", SAA_ERROR_CODE));
     return SI_ERR_CUSTOM_FATAL;
   }

   if (modeltype1 != modeltype2) {
     SIV(SAA_statusBarSet("Elements do not match!", SAA_ERROR_CODE));
     return SI_ERR_CUSTOM_FATAL;
   }

   SIV ( SAA_elementGetUserDataSize( &scene, &target, "NB_POSES",
				     &UDsize ) );
   if (UDsize != 0) {
     if (modeltype1 == SAA_MNSRF || modeltype1 == SAA_MPTCH) {
       savePatch(target, reference);
       calcWeights(target);
     }
     else if (modeltype1 == SAA_MJNT) {
       saveJoint(target, reference);
     } else {
       SIV(SAA_statusBarSet("Wrong type of element!", SAA_ERROR_CODE));
       return SI_ERR_CUSTOM_FATAL;
     }
   }

   return SI_SUCCESS;

}  



_CUS_EXTERN SI_Error RBFenvelopeUpdate
   (
      SAA_CustomContext context
   )
{
  SI_Error result = SI_SUCCESS;
  int nbSelElems;
  SAA_Elem *selElems;
  SAA_ModelType modeltype;
  int UDsize;

  SIV( SAA_sceneGetNbModels( &scene, &nbSelElems ) );
  if( nbSelElems > 0 )
    {
      selElems =
	( SAA_Elem * ) calloc( nbSelElems, sizeof( SAA_Elem ) );
      SIV(SAA_sceneGetModels(&scene, nbSelElems, selElems ));
    }
  
  for(int i=0; i < nbSelElems; i++ ) {
    SIV(SAA_modelGetType( &scene, &selElems[i], &modeltype ));
    if (modeltype == SAA_MNSRF || modeltype == SAA_MPTCH) {
      SIV ( SAA_elementGetUserDataSize( &scene, &selElems[i], "JOINT_LIST",
					&UDsize ) );
      if (UDsize != 0) deformPatch(selElems[i]);
    }
  }
  
  free(selElems);
  return SI_SUCCESS;
  
  
}

_CUS_EXTERN SI_Error RBFenvelopeInit
   (
      SAA_CustomContext context
   )
{

   SAA_CustomContextState state;
   SAA_CustomValueList cusvals;

   /*
   ** Initialize Saaphire.  This is always the first thing that a Saaphire
   ** effect should do.
   */
   SIV(SAA_sceneInit());

   /*
   ** Get the current scene.
   ** Get the models that have been selected.
   */
   SIV(SAA_sceneGetCurrent( &scene ));

   SIV(SAA_customContextGetState( context, &state ));

   if (state == SAA_CUS_RESTORE) {
   }
int nbargs;
SIV(SAA_customContextGetNbArguments(context, &nbargs));
fprintf(stderr, "Checking custom context: %d args\n", nbargs);
SAA_Elem It;
SIV(SAA_customContextGetArguments(context, nbargs, &It));
fprintf(stderr, "and it's %s\n", silGetName(scene, It));

   SAA_Elem *selElems;
   int nbSelElems;
   
   SIV( SAA_sceneGetNbModels( &scene, &nbSelElems ) );
   if( nbSelElems > 0 )
     {
       selElems =
	 ( SAA_Elem * ) calloc( nbSelElems, sizeof( SAA_Elem ) );
       SIV(SAA_sceneGetModels(&scene, nbSelElems, selElems ));
     }
   
   int customSize;
   int nb_joints;
   SAA_Boolean bigendian;
   SAA_Elem *joints;
   char *joint_names;
   
   for (int i=0; i<nbSelElems; ++i) {
     SIV(SAA_elementGetUserDataSize(&scene, &selElems[i], "NB_JOINTS",
				    &customSize));
     SIV( SAA_elementGetUserData( &scene, &selElems[i], "NB_JOINTS",
				  customSize, &bigendian, 
				  &nb_joints) );
     
     if (customSize != 0) {
       joints = (SAA_Elem *)calloc(nb_joints, sizeof(SAA_Elem));
       joint_names = (char *)calloc(nb_joints*NAME_SIZE, 
				    sizeof(char));
       if (joint_names==NULL) fprintf(stderr, "oops\n");
       SIV( SAA_elementGetUserData( &scene, &selElems[i], "NB_JOINTS",
				    customSize, &bigendian, &nb_joints ) );
       SIV( SAA_elementGetUserDataSize( &scene, &selElems[i], "JOINT_NAMES",
					&customSize ) );
       SIV( SAA_elementGetUserData( &scene, &selElems[i], "JOINT_NAMES",
				    customSize, &bigendian, 
				    joint_names) );
       names2elems(joint_names, joints, nb_joints);
       
       SIV(SAA_elementDestroyUserData( &scene, &selElems[i], "JOINT_LIST"));
       SIV(SAA_elementSetUserData(&scene, &selElems[i], "JOINT_LIST",
				  sizeof(SAA_Elem)*nb_joints,
				  TRUE, (void *)joints));
     }
     
   }
   
   free(selElems);
   
   /*
     SIV(SAA_customContextGetCustomValueList(context, &cusvals));
     SIV(SAA_cusvalGetFloatValue(cusvals, "Sigma", &Sigma));
     */
   
   return SI_SUCCESS;
}

void
saveRef(SAA_Elem elem)
{
  int nb_vertices;
  SIV(SAA_modelGetNbVertices(&scene, &elem, &nb_vertices));
  SAA_SubElem *ctrlVert = 
    (SAA_SubElem *) calloc ( nb_vertices, sizeof( SAA_SubElem ) );
  SAA_DVector *vertices = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );

  SIV(SAA_modelGetVertices(&scene, &elem, SAA_GEOM_ORIGINAL, 0,
			   nb_vertices, vertices));
  SIV(SAA_modelGetCtrlVertices(&scene, &elem, SAA_GEOM_ORIGINAL, 0,
			   nb_vertices, ctrlVert ) );

  SAA_Boolean *bigendianary = 
    (SAA_Boolean *) calloc (nb_vertices, sizeof(SAA_Boolean));
  SAA_DVector *refCoord = 
    (SAA_DVector *) calloc ( nb_vertices, sizeof( SAA_DVector ) );
  SAA_DVector **refData = 
    (SAA_DVector **) calloc ( nb_vertices, sizeof( SAA_DVector *) );
  int *UDsubsizes = 
    (int *) calloc ( nb_vertices, sizeof( int ) );
  for (int i=0; i<nb_vertices; ++i) {
    refData[i]=&refCoord[i];
    refCoord[i]=vertices[i];
    UDsubsizes[i]=sizeof(SAA_DVector);
    bigendianary[i]=TRUE;
  }

  SIV(SAA_subelementDestroyUserData( &scene, &elem, nb_vertices, ctrlVert,
                                     "REFERENCE_DATA") );

  SIV(SAA_subelementSetUserData( &scene, &elem, nb_vertices, ctrlVert,
                                 "REFERENCE_DATA", UDsubsizes,
                                 bigendianary, 
                                 (const void **) refData ));
  free(ctrlVert); 
  free(vertices); 
  free(refCoord); 
  free(refData); 
  free(UDsubsizes);
}



int doCalc=1;  //this is very, very bad programming

_CUS_EXTERN SI_Error RBFsetSigma
   (
      SAA_CustomContext context
   )
{
  SAA_CustomValueList cusvals;
  SIV(SAA_customContextGetCustomValueList(context, &cusvals));
  SIV(SAA_cusvalGetFloatValue(cusvals,"Sigma",&Sigma));
fprintf(stderr, "Sigma %f\n", Sigma);

  int nb_patches;
  SAA_Elem *patches;

  SIV( SAA_customContextGetNbResults( context, &nb_patches ) );
  if (nb_patches > 0) {
    patches = (SAA_Elem *)calloc(nb_patches, sizeof(SAA_Elem));
    SIV( SAA_customContextGetResults( context, nb_patches, patches ) );
  }

  for (int i=0; i<nb_patches; ++i) {
    SIV(SAA_elementDestroyUserData( &scene, &patches[i], "SIGMA"));
    SIV(SAA_elementSetUserData(&scene, &patches[i], "SIGMA",
			       sizeof(float), TRUE, &Sigma));
    if (doCalc) calcWeights(patches[i]);
  }

  free(patches);

  return SI_SUCCESS;

}

_CUS_EXTERN SI_Error RBFinitRel
   (
      SAA_CustomContext context
   )
{
   SI_Error		result = SI_ERR_CUSTOM_FATAL;   /* Return value	*/
   int              nbSelElems;  /* number of selected scene elements */
   SAA_Elem         *selElems;   /* pointer on the selected elements */
   SAA_ModelType        modeltype;
   SAA_CustomContextState state;

   static int              nb_joints;    /* number of selected scene elements */
   static SAA_Elem         *joints;     /* pointer on the selected elements */
   static int              nb_patches;
   static SAA_Elem         *patches;
   static char             *joint_names;

   /*
   ** Initialize Saaphire.  This is always the first thing that a Saaphire
   ** effect should do.
   */
   SIV(SAA_sceneInit());

   /*
   ** Get the current scene.
   ** Get the models that have been selected.
   */
   SIV(SAA_sceneGetCurrent( &scene ));
   SIV(SAA_customContextGetState( context, &state ));

   if(state == SAA_CUS_INIT) {

     /*
     SIV(SAA_selectlistGetNbElements( &scene, &nb_joints ));
     if( nb_joints > 0 )
       {
         joints =
	   ( SAA_Elem * ) calloc( nb_joints, sizeof( SAA_Elem ) );
         SIV(SAA_selectlistGetElements(&scene, nb_joints, joints ));
       }
     
     SIV( SAA_selectlistClear( &scene ) );
     */

     SIV( SAA_customContextGetNbResults( context, &nb_patches ) );
     if (nb_patches > 0) {
       patches = (SAA_Elem *)calloc(nb_patches, sizeof(SAA_Elem));
       SIV( SAA_customContextGetResults( context, nb_patches, patches ) );
     }
     SIV( SAA_customContextGetNbArguments( context, &nb_joints ) );
     if (nb_joints > 0) {
       joints = (SAA_Elem *)calloc(nb_joints, sizeof(SAA_Elem));
       SIV( SAA_customContextGetArguments( context, nb_joints, joints ) );
       joint_names = (char *)calloc(nb_joints*NAME_SIZE, sizeof(char));
     }

     int nb_poses=0;
     int customSize;
     for (int i=0; i<nb_patches; ++i) {
       SIV(SAA_elementGetUserDataSize(&scene, &patches[i], "JOINT_LIST",
				      &customSize));
       if (customSize != 0) {
	 SIV(SAA_elementDestroyUserData( &scene, &patches[i], "JOINT_LIST"));
	 SIV(SAA_elementDestroyUserData( &scene, &patches[i], "JOINT_NAMES"));
       }
       else saveRef(patches[i]);

       elems2names(joints, joint_names, nb_joints);
       SIV(SAA_elementSetUserData(&scene, &patches[i], "JOINT_NAMES",
			      sizeof(char)*nb_joints*NAME_SIZE,
			      TRUE, (void *)joint_names));
       SIV(SAA_elementSetUserData(&scene, &patches[i], "JOINT_LIST",
			      sizeof(SAA_Elem)*nb_joints,
			      TRUE, (void *)joints));

       SIV(SAA_elementDestroyUserData( &scene, &patches[i], "NB_JOINTS"));
       SIV(SAA_elementSetUserData(&scene, &patches[i], "NB_JOINTS",
				  sizeof(int), TRUE, &nb_joints));
       SIV(SAA_elementSetUserData(&scene, &patches[i], "NB_POSES",
				  sizeof(int), TRUE, &nb_poses));

     }
     for (int j=0; j<nb_joints; ++j) {
       SIV(SAA_elementGetUserDataSize(&scene, &joints[j], "PATCH_LIST",
				      &customSize));
       if (customSize != 0) 
	 SIV(SAA_elementDestroyUserData( &scene, &joints[j], "PATCH_LIST"));

       SIV(SAA_elementSetUserData(&scene, &joints[j], "PATCH_LIST",
			      sizeof(SAA_Elem)*nb_patches,
			      TRUE, (void *)patches));
       SIV(SAA_elementSetUserData(&scene, &joints[j], "NB_POSES",
				  sizeof(int), TRUE, &nb_poses));
     }

     doCalc=0; //I am ashamed
     RBFsetSigma(context);
     doCalc=1;
   } else if (state == SAA_CUS_RESTORE) {
   } else {
   }

   free(patches);
   free(joints);
   free(joint_names);
   return SI_SUCCESS;

}


#ifdef __cplusplus
}
#endif


