/* rnd.h zilla 16aug from novmac library
 * primitive rnd() algorithm,seed  from acm article (?88).
 * modified
 * 16apr        convert Efloat to Dfloat. Elk doesnt know how to
 *              really pass floats.  see comments in theusual.h
 * 9apr         better ansi
 * 30oct
 * 3sep         small fix
 */

#ifndef RND_H
#define RND_H

#ifndef THEUSUAL_H
#include <theusual.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef RNDstore
#  define RNDglobal
#else
#  define RNDglobal extern
#endif

#ifdef RNDstore
  int4 _rndseed_ = 31415927L;
#else
  extern int4 _rndseed_;
#endif

/*RNDglobal int4 _rndseed_ __ 31415927L _ ;*/

int4 rnd(Zvoid);
Dfloat rndf(Zvoid);
Dfloat rndf11(Zvoid);
bool rndbit Zproto((Zvoid));

int4 rndseed(Zvoid);
int4 rndgetseed(Zvoid);
proc rndsetseed Zproto((int4));

int4 rndchoose Zproto((int4,int4));
Dfloat rndin Zproto((Dfloat,Dfloat));
Dfloat rndg(Zvoid); Dfloat rndgs(Zvoid); /* inv,sampling methods */
Dfloat rnde Zproto((Dfloat));
Dfloat rndomize Zproto((Dfloat,Dfloat));

proc rndftinit Zproto((int,int, Dfloat,Dfloat));
proc rndftfinit(Zvoid);
Dfloat rndft(Zvoid);

Dfloat rndhyperbolic Zproto((Dfloat range));
Dfloat rndoof(Zvoid);
Dfloat rndfjs Zproto((Dfloat oldval,Dfloat factor));
UNSPEC rndfiinit(Zvoid);
Dfloat rndfi Zproto((Dfloat amp,Dfloat frq,Dfloat factor, UNSPEC rcb));

/* table based random number generator */
#define RNDFTABSIZ 61	/* size is prime */
static int _RNDfti = -1;
RNDglobal Efloat _RNDftab[];
#define RNDFT() _RNDftab[ _RNDfti==(RNDFTABSIZ-1) ? _RNDfti=0 : ++_RNDfti ]

#undef __
#undef _

#ifdef __cplusplus
}
#endif

#endif /*RND_H*/
