/* matrix.h zilla -3
 * modified
 * jan01	ansi updates
 * 9apr         ansi updates
 * 25dec
 */

#ifndef MATRIX_H
# define MATRIX_H

#ifdef __cplusplus
extern "C" {
#endif


# if (!( FLTPREC | DBLPREC ))
  macroerror: #define FLTPREC or DBLPREC
# endif
# ifdef Flotype
   macroerror: Flotype
# endif

/* all entries must be renamed here, to eliminate a load conflict
 * in which the wrong-precision library is loaded first, followed
 * (with conflict) by the correct library
 */

#ifdef FLTPREC
# define Flotype float
#else  /*DBLPREC*/
# define Flotype double
# define MatAlloc	dMatAlloc
# define MatFree	dMatFree
# define MatPrint	dMatPrint
# define MatCopy	dMatCopy
# define MatMul 	dMatMul
# define MatXpose	dMatXpose
# define MatInvert	dMatInvert
# define MatInvert2	dMatInvert2
# define MatSolve	dMatSolve
# define MatRandom	dMatRandom
  /* Vector routines */
# define VecAlloc	dVecAlloc
# define VecFree	dVecFree
# define VecPrint	dVecPrint
# define VecCopy	dVecCopy
# define MatVecMul	dMatVecMul
# define VecRandom	dVecRandom
  /* MacKay */
# define mackay_setapprox	dmackay_setapprox
# define mackay_setverbose	dmackay_setverbose
# define mackay_seterrthresh	dmackay_seterrthresh
# define mackaysolve	dmackaysolve
# define mackay		dmackay
#endif /*DBLPREC*/

/* Tracemat((msg,mat,dim)); */
#ifdef	trace
# define Tracemat(msg,mat,dim)  MatPrint(msg,mat,dim)
#else
# define Tracemat(msg,mat,dim) 
#endif	/*trace*/

Flotype *MatAlloc(int4 m,int4 n);
void MatFree(Flotype *);
void MatPrint(char *,Flotype [], int4);
void MatCopy(Flotype *,Flotype *,int4,int4);
void MatMul(Flotype *A,Flotype *B,Flotype *C,int4 N);
void MatXpose(Flotype *A,Flotype *B,int4 N);
void MatRandom(Flotype *,int4,int4);

/* convention - determinant is always returned as a double */
double MatInvert(Flotype [],int4);
double MatInvert2(Flotype *org,Flotype *inv,int4);
double MatSolve(int4,Flotype *A,Flotype *b);
/* Vector */
Flotype *VecAlloc(int4);
void VecFree(Flotype *);
void VecPrint(char *,Flotype*,int4);
void VecCopy(Flotype*,Flotype*,int4);
void VecRandom(Flotype *,int4);
void MatVecMul(Flotype *M,Flotype *V1,Flotype *V2,int4);
/* MacKay*/
double mackaysolve(int,Flotype *M,Flotype *b);
void mackay_setapprox(bool);
void mackay_setverbose(bool);
void mackay_seterrthresh(double);
void mackay(Flotype *A,Flotype *B,int N);

#ifdef __cplusplus
}
#endif

#endif /*MATRIX_H*/
