import java.awt.*;
import javax.swing.*;

import GR.*;
import IF.*;

class PyramidTest
{

  static class avgop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      return (short)((y1x1 + y1x2 + y2x1 + y2x2) / 4);
    }
  }


  static class minminop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      int min1 = (y1x1 < y1x2) ? y1x1 : y1x2;
      int min2 = (y2x1 < y2x2) ? y2x1 : y2x2;
      int min = (min1 < min2) ? min1 : min2;
      return (short)min;
    }
  }

  //----------------------------------------------------------------

  public static void main(String[] args)
  {
    String file = "left.0000.jpg";
    Image img = imageUtil.jpgld(file);
    grImage.store gs = new grImage.store("test", img);
    grImage gg = gs.getComponent(1);

    GPyramid p = new GPyramid("test", gg);
    iPyramidOp pop = new minminop();
    p.restrict(pop);

    JFrame _f = new JFrame();
    JPanel _p = new JPanel();
    _f.getContentPane().add(_p);
    _f.setSize(p.getXres(0), p.getYres(0));
    _f.setVisible(true);

    for( int il=0; il < p.getNlevels(); il++ ) {
      grUtil.dbgdraw((gr)(p._levels.get(il)), _p.getGraphics(), "msg", _f);
    }
  }

} //PyramidTest
