// PyrUtil.java zilla 1998-1999 - pyramid utility functions

import GR.*;
import zlib.*;

public class PyrUtil
{

  /**
   * copy a particular level from one pyramid[] to the other
   */
  public static void copy(Pyramid[] p1, Pyramid[] p2, int level)
  {
    int ncomp = p1.length;
    zliberror.assert(p2.length == ncomp);
    for( int ic=0; ic < ncomp; ic++ ) {
      copy(p1[ic], p2[ic], level);
    }
  } //copy

  /**
   * copy a particular level from one pyramid to the other
   */
  public static void copy(Pyramid p1, Pyramid p2, int level)
  {
    gr g1 = p1.getLevel(level); 
    gr g2 = p2.getLevel(level);
    grUtil.copy(g1, g2);
  } //copy

} //PyrUtil

