import GR.*;
import zlib.*;

public class MMPyramid implements iPyramid
{
  final static boolean 	trace2 = false;

  int _nc;

  Pyramid[]	_minmin;	// array[colorchannel] of ...
  Pyramid[]	_maxmin;
  Pyramid[]	_minmax;
  Pyramid[]	_maxmax;

  public MMPyramid(String name, gr[] img)
  {
    if (img.length >= 3) 
      _nc = 3;
    else 
      _nc = 1;
    zliberror.assert(_nc == img.length);

    _minmin = new Pyramid[_nc];
    _maxmin = new Pyramid[_nc];
    _minmax = new Pyramid[_nc];
    _maxmax = new Pyramid[_nc];

    for( int ic=0; ic < _nc; ic++ ) {
      _minmin[ic] = new Pyramid(name + "-minmin"+ ic, img[ic]);
      _minmin[ic].restrict(new minminop());

      _maxmin[ic] = new Pyramid(name + "-maxmin"+ ic, img[ic]);
      _maxmin[ic].restrict(new maxminop());

      _minmax[ic] = new Pyramid(name + "-minmax"+ ic, img[ic]);
      _minmax[ic].restrict(new minmaxop());

      _maxmax[ic] = new Pyramid(name + "-maxmax"+ ic, img[ic]);
      _maxmax[ic].restrict(new maxmaxop());
    }
  } //constructor

  //----------------------------------------------------------------
  //----------------------------------------------------------------

  public int getNlevels()
  {
    return _minmin[0].getNlevels();
  }

  public int getXres(int level)
  {
    return _minmin[0].getXres(level);
  } //getXres

  public int getYres(int level)
  {
    return _minmin[0].getYres(level);
  } //getXres

  /**
   * Return an array of all the images for this level of the pyramid
   */
  public gr[] getLevel(int level)
  {
    gr[] arr = new gr[_nc * 4];
    int off = 0;

    for( int ic = 0; ic < _nc; ic++ ) {
      arr[off++] = _minmin[ic].getLevel(level);
    }

    for( int ic = 0; ic < _nc; ic++ ) {
      arr[off++] = _maxmin[ic].getLevel(level);
    }

    for( int ic = 0; ic < _nc; ic++ ) {
      arr[off++] = _minmax[ic].getLevel(level);
    }

    for( int ic = 0; ic < _nc; ic++ ) {
      arr[off++] = _maxmax[ic].getLevel(level);
    }

    return arr;
  } //getLevel

  //----------------------------------------------------------------
  //----------------------------------------------------------------

  static class minminop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      int min1 = (y1x1 < y1x2) ? y1x1 : y1x2;
      int min2 = (y2x1 < y2x2) ? y2x1 : y2x2;
      int min = (min1 < min2) ? min1 : min2;
      return (short)min;
    }
  }


  static class maxminop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      int min1 = (y1x1 < y1x2) ? y1x1 : y1x2;
      int min2 = (y2x1 < y2x2) ? y2x1 : y2x2;
      int max = (min1 > min2) ? min1 : min2;
      return (short)max;
    }
  }


  static class minmaxop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      int max1 = (y1x1 > y1x2) ? y1x1 : y1x2;
      int max2 = (y2x1 > y2x2) ? y2x1 : y2x2;
      int min = (max1 < max2) ? max1 : max2;
      return (short)min;
    }
  }


  static class maxmaxop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      int max1 = (y1x1 > y1x2) ? y1x1 : y1x2;
      int max2 = (y2x1 > y2x2) ? y2x1 : y2x2;
      int max = (max1 > max2) ? max1 : max2;
      return (short)max;
    }
  }

  //----------------------------------------------------------------

  final public static class Match extends iMatchcb
  {
    double		_sum;

    MMPyramid		_s0;
    MMPyramid		_s1;

    gr			_s0minmin;
    gr			_s0minmax;
    gr			_s0maxmin;
    gr			_s0maxmax;

    gr			_s1minmin;
    gr			_s1minmax;
    gr			_s1maxmin;
    gr			_s1maxmax;

    //----------------------------------------------------------------

    Match(iPyramid i0, iPyramid i1)
    {
      _s0 = (MMPyramid)i0;
      _s1 = (MMPyramid)i1;

      //_ncalled = 0.;
      _sum = 0.;
    } //constructor

    //----------------------------------------------------------------

    public void clear(iPyramid p0, iPyramid p1, int level,
		      int y, int x, int ywin, int xwin)
    {
      //_ncalled = 0.;
      _sum = 0.;

      _s0minmin = _s0._minmin[0].getLevel(level);
      _s1minmin = _s1._minmin[0].getLevel(level);

      _s0minmax = _s0._minmax[0].getLevel(level);
      _s1minmax = _s1._minmax[0].getLevel(level);

      _s0maxmin = _s0._maxmin[0].getLevel(level);
      _s1maxmin = _s1._maxmin[0].getLevel(level);

      _s0maxmax = _s0._maxmax[0].getLevel(level);
      _s1maxmax = _s1._maxmax[0].getLevel(level);
    } //clear

    //----------------------------------------------------------------

    public void call(iPyramid i0, iPyramid i1, 
		     int level, float weight,
		     int y1,int x1,
		     int y0,int x0)
    {
      if (trace2) System.out.println("minmaxop.call");
      //_ncalled += weight;

      int p0, p1;
      p0 = _s0minmin.rd(x0, y0);
      p1 = _s1minmin.rd(x1, y1);
      _sum += (p0*p1*weight);

      p0 = _s0minmax.rd(x0, y0);
      p1 = _s1minmax.rd(x1, y1);
      _sum += (p0*p1*weight);

      p0 = _s0maxmin.rd(x0, y0);
      p1 = _s1maxmin.rd(x1, y1);
      _sum += (p0*p1*weight);

      p0 = _s0maxmax.rd(x0, y0);
      p1 = _s1maxmax.rd(x1, y1);
      _sum += (p0*p1*weight);
    } //call


    public double getcoef()
    {
      //if (_ncalled == 0) return 0.;
      //return _sum / _ncalled;
      return _sum;
    }
  } //match3minmaxop

  //----------------------------------------------------------------

  public static void main(String[] cmdline)
  {
    try {
      gr[] g = grUtil.loadByExt(cmdline[0]);

      MMPyramid mg = new MMPyramid("test", g);

      mg._minmin[0].save("_tmp_minmin.ppm");
      mg._minmax[0].save("_tmp_minmax.ppm");
      mg._maxmin[0].save("_tmp_maxmin.ppm");
      mg._maxmax[0].save("_tmp_maxmax.ppm");
    }
    catch(Exception x) { zliberror.die(x); }
  } //main

} //MMPyramid
