// GPyramid.java - single channel Greyscale pyramid

// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA  02111-1307, USA.
//
// Primary author contact info:  www.idiom.com/~zilla  zilla@computer.org

import GR.*;

final public class GPyramid extends Pyramid implements iPyramid
{
  final static boolean trace	= false;
  final static boolean trace2	= false;

  public GPyramid(String name, gr img)
  {
    super(name, img, null);
    iPyramidOp pop = new GPyramid.avgop();
    _restrictOp = pop;
    restrict(pop);
  }


  public GPyramid(String name, gr img, iPyramidOp op)
  {
    super(name, img, null);
    _restrictOp = op;
    restrict(op);
  }

  //----------------------------------------------------------------

  final public static class avgop implements iPyramidOp
  {
    public short call(short y1x1, short y1x2, short y2x1, short y2x2)
    {
      return (short)((y1x1 + y1x2 + y2x1 + y2x2) / 4);
    }
  }

  //----------------------------------------------------------------

  final public static class Match extends iMatchcb
  {
    double		_ncalled;
    double		_var0;
    double		_var1;
    double		_sum;

    GPyramid		_g0;
    GPyramid		_g1;

    gr			_gg0;
    gr			_gg1;

    //----------------------------------------------------------------

    Match(iPyramid i0, iPyramid i1)
    {
      _g0 = (GPyramid)i0;
      _g1 = (GPyramid)i1;

      //_ncalled = 0.;
      _sum = 0.;
    } //constructor

    //----------------------------------------------------------------

    public void clear(iPyramid p0, iPyramid p1, int level,
		      int y, int x, int ywin, int xwin)
    {
      _ncalled = 0.;
      _sum = 0.;
      _var0 = 0.;
      _var1 = 0.;

      _gg0 = _g0.getLevel(level);
      _gg1 = _g1.getLevel(level);

    } //clear

    //----------------------------------------------------------------

    public void call(iPyramid i0, iPyramid i1, 
		     int level, float weight,
		     int y1,int x1,
		     int y0,int x0)
    {
      if (trace)
	System.out.println("    m.call "+y1+","+x1+" -> "+y0+","+x0);
      //_ncalled += weight;
      _ncalled += 1.;

      float p0 = weight * _gg0.rd(x0, y0);
      float p1 = weight * _gg1.rd(x1, y1);
      _var0 += (p0*p0);
      _var1 += (p1*p1);
      _sum  += (p0*p1);

    } //call


    public double getcoef()
    {
      if (trace)
	System.out.println("    m.getcoef sum="+_sum+", ncalled="+_ncalled);
      //if (_ncalled == 0) return 0.;
      return _sum / (Math.sqrt(_var0) * Math.sqrt(_var1));
      //return _sum;
    }
  } //match3minmaxop

} //GPyramid

